//###########################################################################
//
// FILE:  	max_baud_rate.c
//
// TITLE: 
//
// NOTE:  
//
//


/*---- example include file -------------------------------------------------*/
#include "DSP281x_Device.h"     // DSP281x Headerfile Include File

void SCIA_GetFiFoData(void);
extern void SCIB_SendStatus(char *);
extern void SCIB_AutobaudLock(void);
extern void SCIA_Init(void);
extern void SCIB_Init(void);
extern void	SCIA_SendHexWord(Uint16);



/*--- Global variables ---*/
#define	YES					1
#define	NO					0
#define	RELOAD_FROM_HT		YES

#define	TRANSFER_SIZE_CKFA	0xC92
#define	RANGE_2810			0x10000	
#define	RANGE_2811			0x20000	
#define	TRANSFER_SIZE_APP	RANGE_2810	

#define	H0_RAM 				0x003F8000
#define SCIA_RAM_START_ADDR	H0_RAM

#define	L1RAM				0x9000
#define CKFA_START_ADDR		L1RAM
	
#define	VDB_EXT_RAM 		0x00080000
#define	eZdsp_EXT_RAM 		0x00100000
#define	TARGET_IS_EZDSP		1
#define	TARGET_IS_VDB		0
#define	TARGET_BOARD		eZdsp_EXT_RAM

#if(TARGET_BOARD==TARGET_IS_EZDSP)
	#define APPCODE_START_ADDR	eZdsp_EXT_RAM
#else
	#define APPCODE_START_ADDR	VDB_EXT_RAM
#endif


Uint16 *ExtRAM;     // Pointer to large ext RAM to hold CKFA & AppCode binary files
Uint32 ExtRAMDestAddr;
Uint16 *CKFA_start_ptr, *CKFA_end_ptr;
Uint16 *AppCode_start_ptr, *AppCode_end_ptr;
Uint16 *SCIA_RAM_start_ptr;
Uint16 transfer_state=0;
Uint16 *SCIA_RAM, temp1, temp2, j, segments;
Uint32 SCIA_RAMDestAddr;

Uint32 i=0;
volatile Uint16 flag_ReadyToTransferCKFA, flag_ReadyToTransferAppCode, flag_ReadyToTransferNextAppCodeSegment;
Uint32 start_time=0, end_time=0, range;
                               
void main(void)
{   

// Step 1. Initialize System Control:
// PLL, WatchDog, enable Peripheral Clocks
// This example function is found in the DSP281x_SysCtrl.c file.
   InitSysCtrl();

// Step 2. Initalize GPIO: 
// This example function is found in the DSP281x_Gpio.c file and
// illustrates how to set the GPIO to it's default state.
// InitGpio();  // Skipped for this example  

   EALLOW;
   GpioMuxRegs.GPFMUX.all=0x0030;	// Select GPIOs to be Scia pins	 
                                    // Port F MUX - x000 0000 0011 0000
   GpioMuxRegs.GPGMUX.all=0x0030;	// Select GPIOs to be Scib pins	 
                                    // Port G MUX - x000 0000 0011 0000
   EDIS;

// Initialize PIE control registers to their default state.
// The default state is all PIE interrupts disabled and flags
// are cleared.  
// This function is found in the DSP281x_PieCtrl.c file.
//   InitPieCtrl();
   
// Disable CPU interrupts and clear all CPU interrupt flags:
   IER = 0x0000;
   IFR = 0x0000;

// Initialize the PIE vector table with pointers to the shell Interrupt 
// Service Routines (ISR).  
// This will populate the entire table, even if the interrupt
// is not used in this example.  This is useful for debug purposes.
// The shell ISR routines are found in DSP281x_DefaultIsr.c.
// This function is found in DSP281x_PieVect.c.
//   InitPieVectTable();

// Interrupts that are used in this example are re-mapped to
// ISR functions found within this file.  
//   EALLOW;	    // This is needed to write to EALLOW protected registers
//   PieVectTable.RXAINT = &rxaint_isr;
//   EDIS;       // This is needed to disable write to EALLOW protected register

// Step 4. Initialize all the Device Peripherals:
// This function is found in DSP281x_InitPeripherals.c
// InitPeripherals(); // Not required for this example
	SCIA_Init();       // Initalize SCIA
	SCIB_Init();       // Initalize SCIB

	if(RELOAD_FROM_HT)
		SCIB_AutobaudLock();  //lock baud with HyperTerminal

	SciaRegs.SCICTL1.bit.SWRESET = 0;
	SciaRegs.SCICTL1.bit.SWRESET = 1;
	SciaRegs.SCIFFTX.bit.SCIFFENA = 1;

	ScibRegs.SCICTL1.bit.SWRESET = 0;
	ScibRegs.SCICTL1.bit.SWRESET = 1;
	ScibRegs.SCIFFTX.bit.SCIFFENA = 1;

	if(RELOAD_FROM_HT)
	{

		ExtRAMDestAddr = CKFA_START_ADDR;
		ExtRAM = (Uint16 *)ExtRAMDestAddr;
		CKFA_start_ptr = ExtRAM;
		SCIB_SendStatus("\n\n\n\n\n\n\n\n\n\n\n\n\rEmulated ICT baud-rate locked, ready for CKFA transfer\n\r ");


		//get CKFA from HyperTerminal
		while((range=ExtRAM-CKFA_start_ptr)<TRANSFER_SIZE_CKFA)
		{
			if(range== 1) 
				SCIB_SendStatus("\r00% transferred");
			else if(range==(TRANSFER_SIZE_CKFA/4)) 
				SCIB_SendStatus("\r25% transferred");
			else if(range==(TRANSFER_SIZE_CKFA/2)) 
				SCIB_SendStatus("\r50% transferred");
			else if(range==(3*TRANSFER_SIZE_CKFA/4)) 
				SCIB_SendStatus("\r75% transferred");

			if(ScibRegs.SCIFFRX.bit.RXFIFST>1) 
				*ExtRAM++ = SCIB_FIFO_GetWordData();

			if(ScibRegs.SCIRXST.bit.RXERROR || ScibRegs.SCIFFRX.bit.RXFFOVF)
			{
			    asm("    ESTOP0");
			    asm("    SB 0, UNC");
			}
		}
		CKFA_end_ptr = ExtRAM;
		SCIB_SendStatus("\rCKFA transferred to simulated ICT\n\r");

		//get AppCode from HyperTerminal
		ExtRAMDestAddr = APPCODE_START_ADDR;
		ExtRAM = (Uint16 *)ExtRAMDestAddr;
		AppCode_start_ptr = ExtRAM;

		if(TRANSFER_SIZE_APP==RANGE_2810)
			SCIB_SendStatus("\n\rReady for 2810 (64kW) AppCode transfer\n\r ");
		else
			SCIB_SendStatus("\n\rReady for 2811 (128kW) AppCode transfer\n\r ");

		while((range=ExtRAM-AppCode_start_ptr)< TRANSFER_SIZE_APP)
		{
			if(range== 1) 
				SCIB_SendStatus("\r00% transferred");
			else if(range==(TRANSFER_SIZE_APP/10)) 
				SCIB_SendStatus("\r10% transferred");
			else if(range==(TRANSFER_SIZE_APP/5)) 
				SCIB_SendStatus("\r20% transferred");
			else if(range==(3*TRANSFER_SIZE_APP/10)) 
				SCIB_SendStatus("\r30% transferred");
			else if(range==(4*TRANSFER_SIZE_APP/10)) 
				SCIB_SendStatus("\r40% transferred");
			else if(range==(TRANSFER_SIZE_APP/2)) 
				SCIB_SendStatus("\r50% transferred");
			else if(range==(6*TRANSFER_SIZE_APP/10)) 
				SCIB_SendStatus("\r60% transferred");
			else if(range==(7*TRANSFER_SIZE_APP/10)) 
				SCIB_SendStatus("\r70% transferred");
			else if(range==(8*TRANSFER_SIZE_APP/10)) 
				SCIB_SendStatus("\r80% transferred");
			else if(range==(9*TRANSFER_SIZE_APP/10)) 
				SCIB_SendStatus("\r90% transferred");

			if(ScibRegs.SCIFFRX.bit.RXFIFST>1) 
			{
				//endian byte swap
				temp1 = SCIB_FIFO_GetWordData();
				temp2 = temp1<<8;
				temp2 |= temp1>>8;			
				*ExtRAM++ = temp2;
	//			*ExtRAM++ = SCIB_FIFO_GetWordData();
			}

			if(ScibRegs.SCIRXST.bit.RXERROR || ScibRegs.SCIFFRX.bit.RXFFOVF)
			{
			    asm("    ESTOP0");
			    asm("    SB 0, UNC");
			}
		}
		AppCode_end_ptr = ExtRAM;
		SCIB_SendStatus("\rAppCode transferred to simulated ICT\n\r ");
	
	} //END if-then(reload_from_HT)



	//set target brd baud rate
	//manually send 'a' or 'A' in Watch Window
	SCIA_RAMDestAddr = SCIA_RAM_START_ADDR;
	SCIA_RAM = (Uint16 *)SCIA_RAMDestAddr;
	SCIA_RAM_start_ptr = SCIA_RAM;

	flag_ReadyToTransferCKFA = 1;	
	SCIB_SendStatus("\n\r*** Ready to lock-in baud-rate with target *** \n\r");
	SCIB_SendStatus("\n\rUse Watch Window for following SCI-A procedure:");
	SCIB_SendStatus("\n\r  1.  Cycle power on target");
	SCIB_SendStatus("\n\r  2.  Reset SCIA by writing a 0 and then a 1 to SciaRegs.SCIFFTX.bit.SCIRST");
	SCIB_SendStatus("\n\r  3.  Lock baud-rate, SciaRegs.SCITXBUF = 'a' ");
	SCIB_SendStatus("\n\r  4.  Verify baud-rate locked, SciaRegs.SCIRXEMU = 'a' ");
	SCIB_SendStatus("\n\r  5.  From CCS, fill Memory (0x3F8000-0x3FA000) with 0x3131");
	SCIB_SendStatus("\n\r  6.  Clear the 'flag_ReadyToTransferCKFA' when baud rate is locked.");
	SCIB_SendStatus("\n\r  7.  After transfer is complete read instructions in Memory Window");
	SCIB_SendStatus("\n\r    a.  Set baud rate, SciaRegs.SCILBAUD = 4");
	SCIB_SendStatus("\n\r    b.  Lock new baud-rate w/target, SciaRegs.SCITXBUF = 'a' ");
	SCIB_SendStatus("\n\r    c.  Erase FLASH, SciaRegs.SCITXBUF = 'y' ");
	SCIB_SendStatus("\n\r    d.  Clear the 'flag_ReadyToTransferAppCode' when baud rate is locked.");

	while(flag_ReadyToTransferCKFA)	//autobaud with target manually
	{
	}
	//After baud locked, set PC to here
	//Send CKFA to target
	//Observe SCIA_RAM for msgs from target
	ExtRAM = CKFA_start_ptr;	
	for(i=0;i<(CKFA_end_ptr-CKFA_start_ptr);i++)
	{
		SCIA_SendHexWordReverse(*ExtRAM++);
//		SCIA_SendHexWord(*ExtRAM++);

//		while(SciaRegs.SCIFFRX.bit.RXFIFST>1) 
		while((SCIA_RAM-SCIA_RAM_start_ptr)<i) 
		{
			*SCIA_RAM++ = SCIA_FIFO_GetWordData();
			if(SciaRegs.SCIRXST.bit.RXERROR || SciaRegs.SCIFFRX.bit.RXFFOVF)
			{
			    asm("    ESTOP0");
			    asm("    SB 0, UNC");
			}
		}
	}

	flag_ReadyToTransferAppCode = 1;	
	while(flag_ReadyToTransferAppCode)
	{
		if(SciaRegs.SCIFFRX.bit.RXFIFST>1) 
			*SCIA_RAM++ = SCIA_FIFO_GetWordData();

		if(SciaRegs.SCIRXST.bit.RXERROR || SciaRegs.SCIFFRX.bit.RXFFOVF)
		{
		    asm("    ESTOP0");
		    asm("    SB 0, UNC");
		}
	}
	//start benchmark
	CpuTimer0Regs.PRD.all = 0xFFFFFFFF;
	CpuTimer0Regs.TIM.all = 0;
	start_time = CpuTimer0Regs.TIM.all;

	ExtRAM = AppCode_start_ptr;
	segments = 1;
	range = (AppCode_end_ptr-AppCode_start_ptr)/segments;

	for(j=0;j<segments;j++)
	{	
		for(i=0;i<range;i++)
		{
			SCIA_SendHexWord(*ExtRAM++);
//			SCIA_SendHexWordReverse(*ExtRAM++);

			if(SciaRegs.SCIFFRX.bit.RXFIFST>1) 
				*SCIA_RAM++ = SCIA_FIFO_GetWordData();
		}	
	//end benchmark
	end_time = CpuTimer0Regs.TIM.all;

		flag_ReadyToTransferNextAppCodeSegment = 1;	
		while(flag_ReadyToTransferNextAppCodeSegment)
		{
			if(SciaRegs.SCIFFRX.bit.RXFIFST>1) 
				*SCIA_RAM++ = SCIA_FIFO_GetWordData();

			if(SciaRegs.SCIRXST.bit.RXERROR || SciaRegs.SCIFFRX.bit.RXFFOVF)
			{
			    asm("    ESTOP0");
			    asm("    SB 0, UNC");
			}

		}

	}  //j for-loop
}


